﻿// Program 4
// CIS 199-50-4228
// Due: 12/2/2022
// By: F2212

// Creates a Product class that tracks supplier Name, product name, product ID, product type, the aisle in which it is found, and whether or not it is in stock
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Security.Cryptography.X509Certificates;
using System.Text;
using System.Threading.Tasks;
using static System.Console;

public class Product
{
    // Constants for validation
    public const int MAX_ID = 999999;
    public const int MIN_ID = 100000;
    public const int MAX_AISLE = 20;
    public const int MIN_AISLE = 1;

    // Default values for properties
    public const int ID_DEFAULT = 000000;
    public const int PRICE_DEFAULT = 0;
    public const int AISLE_DEFAULT = 0;

    // Private fields
    private string _supplierName;
    private string _productName;
    private int _productID;
    private string _productType;
    private double _productPrice;
    private int _aisle;
    private bool? _inStockStatus;

    // Properties with encapsulation and validation
    [Required(ErrorMessage = "Supplier name is required.")]
    public string SupplierName
    {
        get => _supplierName;
        set => _supplierName = value;
    }

    [Required(ErrorMessage = "Product name is required.")]
    public string ProductName
    {
        get => _productName;
        set => _productName = value;
    }

    [Range(MIN_ID, MAX_ID, ErrorMessage = "Product ID must be between 100000 and 999999.")]
    public int ProductID
    {
        get => _productID;
        set => _productID = (value >= MIN_ID && value <= MAX_ID) ? value : ID_DEFAULT;
    }

    [Required(ErrorMessage = "Product type is required.")]
    public string ProductType
    {
        get => _productType;
        set => _productType = value;
    }

    [Range(0, double.MaxValue, ErrorMessage = "Product price must be a positive value.")]
    public double ProductPrice
    {
        get => _productPrice;
        set => _productPrice = (value > 0) ? value : PRICE_DEFAULT;
    }

    [Range(MIN_AISLE, MAX_AISLE, ErrorMessage = "Aisle number must be between 1 and 20.")]
    public int Aisle
    {
        get => _aisle;
        set => _aisle = (value >= MIN_AISLE && value <= MAX_AISLE) ? value : AISLE_DEFAULT;
    }

    // Nullable property for in stock status
    public bool? InStockStatus
    {
        get => _inStockStatus;
    }

    // Methods to update in stock status
    public void InStock()
    {
        _inStockStatus = true;
    }

    public void OutOfStock()
    {
        _inStockStatus = false;
    }

    // Override ToString method
    public override string ToString()
    {
        return $"Supplier Name: {_supplierName}, Product Name: {_productName}, Product ID: {_productID}, Product Type: {_productType}, Aisle: {_aisle}, In Stock: {_inStockStatus}";
    }

    // Constructor with parameters
    public Product(string supplier, string product, int productID, string productType, double productPrice, bool inStock)
    {
        SupplierName = supplier;
        ProductName = product;
        ProductID = productID;
        ProductType = productType;
        ProductPrice = productPrice;
        _inStockStatus = inStock;
    }
}
